package com.humuson.tms.batch.job.tasklet;

import java.util.HashMap;
import java.util.Map;

import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

import com.humuson.tms.batch.job.constrants.JobParamConstrants;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class DeleteTempTasklet implements Tasklet {

	@Autowired 
	private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	@Setter private String deleteTempSendList;
	
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {

		JobParameters jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters();
		
		try {
			log.info("[DeleteTempTasklet] Delete TempTargetlist START");
			Map<String, String> paramMap =  new HashMap<String,String>();
			paramMap.put("msgId", jobParameters.getString(JobParamConstrants.MSG_ID));
			int res = namedParameterJdbcTemplate.update(deleteTempSendList, paramMap);
			log.info("[DeleteTempTasklet] SUCCESS msgId : {}, DelCnt : {}, ",jobParameters.getString(JobParamConstrants.MSG_ID),res);
			
		} catch (Exception e){
			log.error("[DeleteTempTasklet] Exception : {} ",e.getMessage());
		}
		
		return RepeatStatus.FINISHED;
		
	}	
}
