package com.humuson.tms.batch.job.tasklet;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.CustomQueueTableRow;

import lombok.Setter;

/**
 * 연동 발송 큐 테이블의 데이터를 주기적으로 지워주는 역할을 하는 클래스
 * 
 * @author hyogun
 *
 */
public class DeleteQueueTableCheckTasklet implements Tasklet {
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	@Setter private String selectQueueTableIdSql;
	@Setter private String deleteQueueTableRecords;
	
	@Value("#{config['use.delete.queue.table']}")
	protected boolean useDeleteQueueTable;
	
	@Value("#{config['delete.queue.table.list']}")
	protected String queueTables;
	
	@Value("#{config['delete.queue.table.cycle']}")
	protected int cycle;
	
	Logger logger = LoggerFactory.getLogger(DeleteQueueTableCheckTasklet.class);
		
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		String queueTableList[];
		
		if (!useDeleteQueueTable) {
			// Do nothing
			return RepeatStatus.FINISHED;
		} else {
			queueTableList = queueTables.split(",");
			
			if (queueTableList.length < 1) {
				logger.info("Not found queue table list in env file.");
				return RepeatStatus.FINISHED;
			}
		}
		
		List<CustomQueueTableRow> list = null;
		
		String query = null;
		
		for (int i = 0; i < queueTableList.length; i++) {
			
			logger.info("Queue table delete for : {}", queueTableList[i]);
			
			do {
				list = new ArrayList<CustomQueueTableRow>();
				
				query = selectQueueTableIdSql.replace("@QUEUE_TABLE@", queueTableList[i]);
				logger.debug("SELECT QUERY : {}", query);
				
				list = jdbcTemplate.query(query, new CustomQueueTableRowMapper(), cycle);
				
				List<Object[]> seqParams = new ArrayList<Object[]>();
				
				for (CustomQueueTableRow row : list) {
					seqParams.add(new Object[]{row.getSeq()});
				}
				
				logger.info("delete queue table start [size:{}]", list.size());
				
				query = deleteQueueTableRecords.replace("@QUEUE_TABLE@", queueTableList[i]);
				logger.debug("DELETE QUERY : {}", query);
				
				try {
					jdbcTemplate.batchUpdate(query, seqParams);
				} catch (Exception e) {
					logger.error("delete queue table error", e);
					for (Object[] param : seqParams) {
						try {
							jdbcTemplate.update(query, param);
						} catch (Exception e2) {
							// TODO: handle exception
							logger.error("delete queue table error skip param [seq:{}]", param[0]);
						}
					}
				}
				
			} while(!list.isEmpty());
			
		}
		
		return RepeatStatus.FINISHED;
		
	}
	
	public class CustomQueueTableRowMapper implements RowMapper<CustomQueueTableRow> {

		public CustomQueueTableRow mapRow(ResultSet rs, int rownum) throws SQLException {
			CustomQueueTableRow bean = new CustomQueueTableRow();
			bean.setSeq(rs.getLong("SEQ"));
			return bean;
		}
	}
	
}
