package com.humuson.tms.batch.job.tasklet;

import java.util.Calendar;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.common.util.FatigueListTableNameUtil;
import com.humuson.tms.constrants.ChannelType;

import lombok.Setter;

import lombok.extern.slf4j.Slf4j;

/**
 * 피로도 테이블 (TMS_FATIGUE_LIST) 에서 오래된 데이터 제거
 *
 * @author kmc
 *
 */
@Slf4j
public class DeleteFatigueListTasklet implements Tasklet {

	@Autowired
	private JdbcTemplate jdbcTemplate;

	@Setter private String truncateFatigueListSql;
	
	private final String TABLE_NAME = "@@TABLE_NAME@@";
	private final String PARTITION_NAME = "@@PARTITION_NAME@@";
	private final String PARTITION_PREFIX_NAME = "P_FATIGUE_";
	
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		Calendar cal = Calendar.getInstance();
		

        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH)+1;
		String yearMonth = null;
		
		// 이전달로 설정.
		if(month == 1){
			year = year - 1;
			month = 12;
		}else{
			month = month - 1;
		}
		
        if(month <10){
        	yearMonth = year+"0"+month;
        }else{
        	yearMonth = year+""+month;
        }
        
		try {
			log.info("Truncate fatigue list start");
			String sql = null;
			String tableName = null;
			String partitionName = null;
			for(ChannelType chn : ChannelType.values()){
				sql = truncateFatigueListSql;
				tableName = FatigueListTableNameUtil.getFatigueListTableName(chn.getCode());
				if(tableName == null){
					continue;
				}
				if(chn.getCode().equals(chn.LMS.getCode())){
					continue;
				}
				//
				if(chn.getCode().equals("KA")){
					partitionName = PARTITION_PREFIX_NAME + "KAKAO_"+yearMonth;
				}else{
					partitionName = PARTITION_PREFIX_NAME + chn.getName()+ "_"+yearMonth;
				}
				sql = sql.replace(TABLE_NAME, tableName);
				sql = sql.replace(PARTITION_NAME, partitionName);
				
				int count = jdbcTemplate.update(sql);
				log.info("Truncate Success ChannelType : {} / Partition Table : {} Partition Name : {}" , chn.getCode(), tableName, partitionName);
			}
			log.info("Truncate fatigue list end");
			
		} catch ( Exception e ) {
			log.error("delete fatigue list error", e);
		}

		return RepeatStatus.FINISHED;

	}

}
