package com.humuson.tms.batch.job.tasklet;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import lombok.Setter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.BatchJobExeRow;

/**
 * BATCH 작업에 대한 이력 테이블을 데이터를 삭제하는 클래스
 * 
 * @author hyogun
 *
 */
public class DeleteBatchScheduleCheckTasklet implements Tasklet {
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	@Setter private String selectJobInstanceIdSql;
	@Setter private String deleteBatchJobExecutionContext;
	@Setter private String deleteBatchJobExecutionParam;
	@Setter private String deleteBatchJobExecution;
	@Setter private String deleteBatchJobInstance;
	@Setter private String deleteStepExecutionContext, deleteStepExecution;
	
	Logger logger = LoggerFactory.getLogger(DeleteBatchScheduleCheckTasklet.class);
		
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		List<BatchJobExeRow> list = new ArrayList<BatchJobExeRow>();
		
		do {
			list = jdbcTemplate.query(selectJobInstanceIdSql, new BatchJobRowMapper());
			
			List<Object[]> jobExecutionIdParams = new ArrayList<Object[]>();
			List<Object[]> jobInstanceIdParams = new ArrayList<Object[]>();
			
			for (BatchJobExeRow row : list) {
				jobExecutionIdParams.add(new Object[]{row.getJobExecutionId()});
				jobInstanceIdParams.add(new Object[]{row.getJobInstanceId()});
			}
			
			logger.info("deleteStepExecutionContext start [size:{}]", list.size());
			try {
				
				jdbcTemplate.batchUpdate(this.deleteStepExecutionContext, jobExecutionIdParams);
			} catch (Exception e) {
				logger.error("deleteStepExecutionContext error", e);
				for (Object[] param : jobExecutionIdParams) {
					try {
						jdbcTemplate.update(deleteStepExecutionContext, param);
					} catch (Exception e2) {
						// TODO: handle exception
						logger.error("deleteStepExecutionContext error skip param[jobExcutionId:{}]", param[0]);
					}
				}
			}
			
			logger.info("deleteBatchJobExecutionContext start [size:{}]", list.size());
			try {
				jdbcTemplate.batchUpdate(this.deleteBatchJobExecutionContext, jobExecutionIdParams);
			} catch (Exception e) {
				// TODO: handle exception
				logger.error("deleteBatchJobExecutionContext error", e);
				for (Object[] param : jobExecutionIdParams) {
					try {
						jdbcTemplate.update(deleteBatchJobExecutionContext, param);
					} catch (Exception e2) {
						// TODO: handle exception
						logger.error("deleteBatchJobExecutionContext error skip param[jobExcutionId:{}]", param[0]);
					}
				}
			}
			
			logger.info("deleteStepExecution start [size:{}]", list.size());
			try {
				jdbcTemplate.batchUpdate(this.deleteStepExecution, jobExecutionIdParams);
			} catch (Exception e) {
				// TODO: handle exception
				logger.error("deleteStepExecution error", e);
				for (Object[] param : jobExecutionIdParams) {
					try {
						jdbcTemplate.update(deleteStepExecution, param);
					} catch (Exception e2) {
						// TODO: handle exception
						logger.error("deleteStepExecution error skip param[jobExcutionId:{}]", param[0]);
					}
				}
			}
			
			logger.info("deleteBatchJobExecutionParam start [size:{}]", list.size());
			try {
				jdbcTemplate.batchUpdate(this.deleteBatchJobExecutionParam, jobExecutionIdParams);
			} catch (Exception e) {
				// TODO: handle exception
				logger.error("deleteBatchJobExecutionParam error", e);
				for (Object[] param : jobExecutionIdParams) {
					try {
						jdbcTemplate.update(deleteBatchJobExecutionParam, param);
					} catch (Exception e2) {
						// TODO: handle exception
						logger.error("deleteBatchJobExecutionParam error skip param[jobExcutionId:{}]", param[0]);
					}
				}
			}
			
			logger.info("deleteBatchJobExecution start [size:{}]", list.size());
			try {
				jdbcTemplate.batchUpdate(this.deleteBatchJobExecution, jobExecutionIdParams);
			} catch (Exception e) {
				// TODO: handle exception
				logger.error("deleteBatchJobExecution", e);
				for (Object[] param : jobExecutionIdParams) {
					try {
						jdbcTemplate.update(deleteBatchJobExecution, param);
					} catch (Exception e2) {
						// TODO: handle exception
						logger.error("deleteBatchJobExecution error skip param[jobExcutionId:{}]", param[0]);
					}
				}
			}
			
			logger.info("deleteBatchJobInstance start [size:{}]", list.size());
			try {
				jdbcTemplate.batchUpdate(this.deleteBatchJobInstance, jobInstanceIdParams);
			} catch (Exception e) {
				// TODO: handle exception
				logger.error("deleteBatchJobInstance error ", e);
				for (Object[] param : jobInstanceIdParams) {
					try {
						jdbcTemplate.update(deleteBatchJobInstance, param);
					} catch (Exception e2) {
						// TODO: handle exception
						logger.error("deleteBatchJobInstance error skip param[jobExcutionId:{}]", param[0]);
					}
				}
			}
			list = new ArrayList<BatchJobExeRow>();
		} while(!list.isEmpty());
		
		return RepeatStatus.FINISHED;
		
	}
	
	public class BatchJobRowMapper implements RowMapper<BatchJobExeRow> {

		public BatchJobExeRow mapRow(ResultSet rs, int rownum) throws SQLException {
			// TODO Auto-generated method stub
			BatchJobExeRow bean = new BatchJobExeRow();
			bean.setJobExecutionId(rs.getLong("JOB_EXECUTION_ID"));
			bean.setJobInstanceId(rs.getLong("JOB_INSTANCE_ID"));
			return bean;
		}

	}
}
