package com.humuson.tms.batch.job.tasklet;

import java.util.List;
import java.util.Map;

import lombok.Setter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.batch.domain.App;

/**
 * 앱 사용자 수 갱신 프로세스
 * 
 * @author hyogun
 *
 */
public class DailyBatchSummaryTasklet implements Tasklet {
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	@Setter private String selectYesterdayNewSession, updateAppUserCount;
	
	Logger logger = LoggerFactory.getLogger(DailyBatchSummaryTasklet.class);
		
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		List<Map<String, Object>> list = jdbcTemplate.queryForList(selectYesterdayNewSession, new Object[]{});
		
		int grpId=0, userCount = 0;
		long startTime = 0L;
		
		for (Map<String, Object> appInfo : list) {
			startTime = System.currentTimeMillis();
			
			if (appInfo.get(App.APP_GRP_ID) != null) {
				try {
					grpId = Integer.parseInt(appInfo.get(App.APP_GRP_ID).toString());
					userCount = Integer.parseInt(appInfo.get("NEW_SESS_CNT").toString());
					jdbcTemplate.update(updateAppUserCount, userCount, grpId);
				} catch (Exception e) {
					logger.error("update user_count error", e);
				} finally {
					logger.info("[appGrpId:{}] update user_count += {} elapseTime:{}", grpId, userCount, (System.currentTimeMillis() - startTime));
				}
			}
		}
		
		return RepeatStatus.FINISHED;
		
	}
}
