package com.humuson.tms.batch.job.tasklet;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 안드로이 앱 삭제자 리스트 테이블을 삭제하는 클래스.
 * 
 * @author sgeom
 *
 */
@Slf4j
public class ClearDeleteDeviceListTasklet implements Tasklet {
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	@Setter private String clearDeleteDeviceListSql;
	@Setter private String clearDeleteDeviceListUsingTruncateSql;
	
	@Value("#{config['delete.type.is.truncate']}")
	protected boolean isTruncate;
	
	@Override
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		log.info("delete.type.is.truncate : {}", isTruncate);
		try{
			if(isTruncate){
				jdbcTemplate.execute(clearDeleteDeviceListUsingTruncateSql);
			}else{
				jdbcTemplate.execute(clearDeleteDeviceListSql);
			}
		}catch(Exception e){
			log.error("clearDeleteDeviceListSql Fail : {}",e);
		}
		
		return RepeatStatus.FINISHED;
		
	}
	
}
