package com.humuson.tms.batch.job.partition;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class KeyDivider {
	
	private int[] divisionCount;
	private String[] ids;
	private int position = 0;
	private int cumulativeCount = 0;
	private String keyName, valueName;
	
	public KeyDivider(String keyName, String valueName) {
		this.keyName = keyName;
		this.valueName = valueName;
	}
	
	public double getPercent(Properties server){
		return Double.parseDouble(server.getProperty(this.valueName, "50"));
    }
	
	public boolean isServerListZero(int totalCount, List<Properties> idList){
		if(idList == null || idList.isEmpty()){
			defaultInit();
			return true;
		} else {
			return false;
		}
	}
	

	/**
	 * 
		 * <PRE>
		 * 1. MethodName: defaultInit
		 * 2. ClassName : ServerIdController.java
		 * 3. Comment   : 기본 Server ID를 01로 설정 한다. 
		 * 4. 작성자    : pioneer
		 * 5. 작성일    : 2013. 9. 6.-오후 10:24:46
		 * </PRE>
		 *   @return void
		 *   @param
	 */
	public void defaultInit(){
		divisionCount = new int[position+1];
		divisionCount[position]= 1000000000;
		ids = new String[position+1];
		ids[position] = "01";
	}
//	
//	
	public void defaultInit(int totalCount){
		if(totalCount <=0) defaultInit();
		
		divisionCount = new int[position+2];
		ids = new String[position+2];
		divisionCount[0]= totalCount/2;
		ids[0] = "01";
		divisionCount[1]= totalCount+1;
		ids[1] = "02";
	}
	
	/**
	 * 포지션 위치를 결정 한다.
		 * <PRE>
		 * 1. MethodName: setPosition
		 * 2. ClassName : ServerIdController.java
		 * 3. Comment   : 프로세스가 중지 되고 다시 시작할 때 필요하다.  
		 * 4. 작성자    : pioneer
		 * 5. 작성일    : 2013. 9. 7.-오후 5:51:56
		 * </PRE>
		 *   @return void
		 *   @param @param count
	 */
	public void setPosition(int count){
		for (int i = 0; i < divisionCount.length; i++) {
			if(divisionCount[i] > count){ 
				position = i;
				return;
			}
		}
	}

	/**
	 * 
		 * <PRE>
		 * 1. MethodName: divisionId
		 * 2. ClassName : ServerIdController.java
		 * 3. Comment   : 담당자가 설정한  xx% 별로 ServerID를 분배한다.
		 * 4. 작성자    : pioneer
		 * 5. 작성일    : 2013. 9. 6.-오후 10:34:48
		 * </PRE>
		 *   @return void
		 *   @param  totalCount : 타겟팅 전체 카운트 
		 *   @param  serverList : 분배할 서버 정보<Properties> : SERVER_ID, PERCENT 
		 *   @throws Exception
	 */
	public void divisionId(int totalCount, List<Properties> serverList)
	throws Exception{
		if(isServerListZero(totalCount, serverList)){
			return;
		}
		try {
			divisionCount = new int[serverList.size()];
			ids = new String[serverList.size()];
			for (int i = 0; i < divisionCount.length; i++) {
				divisionCount[i] = 
						(int)(totalCount * getPercent(serverList.get(i))/100) + cumulativeCount;
				if (divisionCount[i] == 0) {
					divisionCount[i] = 1;
				}
				cumulative(divisionCount[i]);
				ids[i]= serverList.get(i).getProperty(this.keyName); 
			}	
			divisionCount[divisionCount.length-1] = divisionCount[divisionCount.length-1] + serverList.size()+1;
		} catch (Exception e) {
			log.error("divisionServer error", e);
			isServerListZero(totalCount, serverList);
		}
	}

	private void cumulative(int count){
		cumulativeCount = count;
	}
	
	/**
	 * 
		 * <PRE>
		 * 1. MethodName: getServerId
		 * 2. ClassName : ServerIdController.java
		 * 3. Comment   : 현재 Count 정보에 맞는 Key 반환한다. </br> 성능 포커스 
		 * 4. 작성자    : pioneer
		 * 5. 작성일    : 2013. 9. 6.-오후 10:13:16
		 * </PRE>
		 *   @return String "01", "02" ...
		 *   @param count
		 *   
	 */
	public String getId(long count){
		try {
			return (divisionCount[position] > count) ? ids[position] : ids[++position];
		} catch (Exception e) {
			log.error("count :{}, divisionCount:{}, position:{}", count, divisionCount.length, position);
			e.printStackTrace();
			return ids[position];
		} 
	}
	
	public String toString(){
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < divisionCount.length; i++) {
			try {
				if (i > 0) sb.append(" , ");
				sb.append("{id[").append(i).append("]=").append(ids[i]).append(",");
				sb.append("divisionCount[").append(i)
					.append("]=").append(divisionCount[i])
					.append("}");
				
			} catch (Exception e) {
				log.error("toString error [toString:{}]", sb.toString(), e);
			}
		}
		return sb.toString();
	}
	
	public static void main(String[] args) {
		KeyDivider s = new KeyDivider("SERVER_ID", "PARTICIPATION_RATE");
		ArrayList<Properties> list = new ArrayList<Properties>();
		
		Properties prop = new Properties();
		prop.setProperty("SERVER_ID", "01");
		prop.setProperty("PARTICIPATION_RATE", "10.0");
		list.add(prop);
		Properties prop1 = new Properties();
		prop1.setProperty("SERVER_ID", "02");
		prop1.setProperty("PARTICIPATION_RATE", "10.0"); 
		list.add(prop1);
		Properties prop2 = new Properties();
		prop2.setProperty("SERVER_ID", "03");
		prop2.setProperty("PARTICIPATION_RATE", "80.0"); 
		list.add(prop2);
		
		try {
			int targetCnt = 10;
			s.divisionId(targetCnt, list);
			for (int i=0; i<targetCnt; i++) {
				System.out.println(i+" "+s.getId(i));
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println(s.toString());
	}
}
