package com.humuson.tms.batch.job.listener;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

import lombok.extern.slf4j.Slf4j;

/**
 * PUSH / SMS 결과 업데이트 JOB Listener
 * @author hyogun
 *
 */
@Slf4j
public class UpdateJobListener implements JobExecutionListener {
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		
		log.info("End jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

}
