package com.humuson.tms.batch.job.listener;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.TargetSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.TargetStatus;

@Slf4j
public class TargetingJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<TargetSchedule> targetingScheduleService;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
//		String postId = jobExecution.getJobParameters().getString(JobParamConstrants.POST_ID);
//		targetingScheduleService.updateScheduleStatus(postId, TargetStatus.SENDING.getCode());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		String msgId = jobExecution.getJobParameters().getString(JobParamConstrants.MSG_ID);
		
		log.info("End jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		
		this.targetingScheduleService.setRunning(msgId, false);
		
		if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
			targetingScheduleService.updateScheduleStatus(msgId, TargetStatus.COMPLETE.getCode());
		} else if (jobExecution.getStatus() == BatchStatus.STOPPED
				|| jobExecution.getStatus() == BatchStatus.STOPPING) { 
			targetingScheduleService.updateScheduleStatus(msgId, TargetStatus.CANCEL_COMPLETE.getCode());
		} else {
			targetingScheduleService.updateScheduleStatus(msgId, TargetStatus.ERROR.getCode());
		}
	}

}
