package com.humuson.tms.batch.job.listener;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.SmsUpdateSchedule;
import com.humuson.tms.batch.service.ScheduleService;


/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class SmsUpdateJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<SmsUpdateSchedule> smsUpdateScheduleService;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		
		log.info("End jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		smsUpdateScheduleService.setRunning("SmsUpdateScheduler", false);
	}

}
