package com.humuson.tms.batch.job.listener;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.PushUpdateSchedule;
import com.humuson.tms.batch.service.ScheduleService;
;
/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class PushUpdateJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<PushUpdateSchedule> pushupdateScheduleService;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		
		log.info("End jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		pushupdateScheduleService.setRunning(jobExecution.getJobInstance().getJobName(), false);
	}

}
