package com.humuson.tms.batch.job.listener;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.PushReSendSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.ScheduleService;
;

@Slf4j
public class PushReSendJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<PushReSendSchedule> pushSendScheduleService;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		
		log.info("End jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		String appGrpKey = jobExecution.getJobParameters().getString(JobParamConstrants.APP_GRP_KEY, "");
		String serverId = jobExecution.getJobParameters().getString(JobParamConstrants.SERVER_ID, "");
		String sendType = jobExecution.getJobParameters().getString(JobParamConstrants.SEND_TYPE, "");
		pushSendScheduleService.setRunning(appGrpKey+"-"+sendType+"-"+serverId, false);
	}

}
