package com.humuson.tms.batch.job.listener;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.PushMqReSendSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.ScheduleService;

import lombok.extern.slf4j.Slf4j;
;

@Slf4j
public class PushMqReSendJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<PushMqReSendSchedule> pushMqReSendScheduleService;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		
		log.info("End jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		String appGrpKey = jobExecution.getJobParameters().getString(JobParamConstrants.APP_GRP_KEY, "");
		String serverId = jobExecution.getJobParameters().getString(JobParamConstrants.SERVER_ID, "");
		String sendType = jobExecution.getJobParameters().getString(JobParamConstrants.SEND_TYPE, "");
		pushMqReSendScheduleService.setRunning(appGrpKey+"-"+sendType+"-"+serverId, false);
	}

}
