package com.humuson.tms.batch.job.listener;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.OptmzSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.OptmzChannelService;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.StatusType;

@Slf4j
public class OptmzManualChannelJobListener implements JobExecutionListener {

	@Autowired private OptmzChannelService optmzManualChannelService;
	@Autowired private ScheduleService<OptmzSchedule> optmzManualChnTargetScheduleService;
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		
		String postId = jobExecution.getJobParameters().getString(JobParamConstrants.POST_ID);
		String msgId = jobExecution.getJobParameters().getString(JobParamConstrants.MSG_ID);
		String channelType = jobExecution.getJobParameters().getString(JobParamConstrants.CHN_TYPE);
		
		this.optmzManualChannelService.insertTargetServer(postId, msgId, channelType);
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		log.info("End jobName:{}, status:{}, param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getStatus(),
				jobExecution.getJobParameters().toProperties());
		String postId = jobExecution.getJobParameters().getString(JobParamConstrants.POST_ID);
		String msgId = jobExecution.getJobParameters().getString(JobParamConstrants.MSG_ID);
		String channelType = jobExecution.getJobParameters().getString(JobParamConstrants.CHN_TYPE);
		
		if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
			// TODO UPDATE TARGET_SERVER.TARGET_CNT 
			String stepApprovalUseYn = jobExecution.getJobParameters().getString(JobParamConstrants.STEP_APPROVAL_USE_YN);
			log.info("optmz schedule regist STEP_APPROVAL_USE_YN : {}", stepApprovalUseYn);
			this.optmzManualChannelService.registScheduleInfo(postId, msgId, channelType,stepApprovalUseYn);
			log.info("optmz schedule regist");
			this.optmzManualChnTargetScheduleService.updateScheduleStatus(postId, StatusType.COMPLETE.getCode());
		} else {
			// TODO job failed...
			log.error("optmz schedule error");
			this.optmzManualChnTargetScheduleService.updateScheduleStatus(postId, StatusType.ERROR.getCode());
		}
	}

}
