package com.humuson.tms.batch.job.listener;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.ScheduleService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class FatigueFilterJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<FatigueFilterSchedule> fatigueFilterScheduleService;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobInstance().getJobName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		log.info("End jobName: {} ,param:[{}], elapseTime:{}", jobExecution.getJobInstance().getJobName(), 
				jobExecution.getJobParameters().toProperties());
		String postId = jobExecution.getJobParameters().getString(JobParamConstrants.POST_ID);
		fatigueFilterScheduleService.setRunning(postId, false);
	}

}
