package com.humuson.tms.batch.job.listener;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.DirectPushSendSchedule;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.batch.service.ScheduleService;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class DirectPushSendJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<DirectPushSendSchedule> directPushSendScheduleService;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		
		log.info("End jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		String appGrpKey = jobExecution.getJobParameters().getString(JobParamConstrants.APP_GRP_KEY, "");
		directPushSendScheduleService.setRunning(appGrpKey, false);
	}

}
