package com.humuson.tms.batch.job.listener;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.AndroidDelDeviceCleanzingSchedule;
import com.humuson.tms.batch.service.ScheduleService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class AndroidDelDeviceCleanzingJobListener implements JobExecutionListener {
	
	@Autowired
	private ScheduleService<AndroidDelDeviceCleanzingSchedule> androidDelDeviceCleanzingSchedule;
	
	@Override
	public void beforeJob(JobExecution jobExecution) {
		log.info("Start jobName: {} ,param:[{}]", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
	}

	@Override
	public void afterJob(JobExecution jobExecution) {
		log.info("End jobName: {} ,param:[{}], elapseTime:{}", jobExecution.getJobConfigurationName(), 
				jobExecution.getJobParameters().toProperties());
		androidDelDeviceCleanzingSchedule.setRunning(jobExecution.getJobInstance().getJobName(), false);
	}

}
