package com.humuson.tms.batch.job.launcher;

import java.util.Date;
import java.util.Map;
import java.util.Map.Entry;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.scheduling.quartz.QuartzJobBean;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class JobLauncherQuartzBean extends QuartzJobBean {
	
	public static final String KEY_JOB_PARAM_DATE = "quartz_job_date";
	public static final String JOB_LOCATOR_CONTEXT_KEY = "jobLocator";
	public static final String JOB_LAUNCHER_CONTEXT_KEY = "jobLauncher";
	public static final String JOB_NAME = "jobName";
	
	JobLocator jobLocator;

	JobLauncher jobLauncher;
	
	private void init(JobExecutionContext context) {
		try {
			jobLocator = (JobLocator) context.getScheduler().getContext().get(JOB_LOCATOR_CONTEXT_KEY);
			jobLauncher = (JobLauncher) context.getScheduler().getContext().get(JOB_LAUNCHER_CONTEXT_KEY);
		} catch (SchedulerException e) {
			log.error("JobLauncherQuartzBean init error", e);
		}  
		
	}
	
	protected JobParameters getJobParametersFromJobMap(Map<String, Object> jobDataMap) {

		JobParametersBuilder builder = new JobParametersBuilder();

		for (Entry<String, Object> entry : jobDataMap.entrySet()) {
			String key = entry.getKey();
			Object value = entry.getValue();
			if (value instanceof String && !key.equals(JOB_NAME)) {
				builder.addString(key, (String) value);
			}
			else if (value instanceof Float || value instanceof Double) {
				builder.addDouble(key, ((Number) value).doubleValue());
			}
			else if (value instanceof Integer || value instanceof Long) {
				builder.addLong(key, ((Number)value).longValue());
			}
			else if (value instanceof Date) {
				builder.addDate(key, (Date) value);
			}
			else {
				log.debug("JobDataMap contains values which are not job parameters (ignoring). [key:{}, value:{}]", key, value);
			}
		}
		
		return builder.toJobParameters();
	}
	
	@Override
	protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
		
		init(context);
		
		Map<String, Object> jobDataMap = context.getMergedJobDataMap();
		
		//항상 새로운 job instance로 실행한다.
		jobDataMap.put(KEY_JOB_PARAM_DATE, System.currentTimeMillis());

		String jobName = jobDataMap.get(JOB_NAME).toString();
		
		JobParameters jobParameters = getJobParametersFromJobMap(jobDataMap);
			
		try {
			jobLauncher.run(jobLocator.getJob(jobName), jobParameters);
		} catch (Exception e) {
			log.error("job execute error jobName : {}, jobParameters : [{}]",jobName,jobParameters);
		}
	}

}
