package com.humuson.tms.batch.job.decision;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;

import lombok.extern.slf4j.Slf4j;

/**
 * 타겟 건수에 따라 single thread or multi thread로 구동 여부를 판단
 * @author hyogun
 *
 */
@Slf4j
public class ThreadTypeDecider implements JobExecutionDecider {
	
	private int singleThreadMaxTargetCount = 1000;
	
	@Override
	public FlowExecutionStatus decide(JobExecution jobExecution,
			StepExecution stepExecution) {
		
		if (ExitStatus.COMPLETED.getExitCode().equals(stepExecution.getExitStatus().getExitCode())) {
			int totalTargetCnt = stepExecution.getJobExecution()
					.getExecutionContext().getInt(JobExecutionContextConstrants.KEY_TOT_COUNT);
			
			if (totalTargetCnt > singleThreadMaxTargetCount) {
				return new FlowExecutionStatus("MULTI");
			} else {
				return new FlowExecutionStatus("SINGLE");
			}
		} else {
			log.error("Step ExistCode:{}, param[{}]", 
					stepExecution.getExitStatus().getExitCode(), stepExecution.toString());
		}
		return new FlowExecutionStatus(ExitStatus.STOPPED.getExitCode());
	}

}
