package com.humuson.tms.batch.job.decision;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

import com.humuson.tms.batch.job.constrants.JobParamConstrants;

@Slf4j
public class TargetTypeDecider implements JobExecutionDecider {

	@Override
	public FlowExecutionStatus decide(JobExecution jobExecution,
			StepExecution stepExecution) {
		if (ExitStatus.COMPLETED.getExitCode().equals(stepExecution.getExitStatus().getExitCode())) {
			String targetType = stepExecution.getJobExecution()
					.getExecutionContext().get(JobParamConstrants.TARGET_TYPE).toString();
			log.info("targetType : {}", targetType);
			return new FlowExecutionStatus(targetType);
		} else {
			log.error("Step ExistCode:{}, param[{}]", 
					stepExecution.getExitStatus().getExitCode(), stepExecution.toString());
		}
		return new FlowExecutionStatus(ExitStatus.STOPPED.getExitCode());
	}

}
