package com.humuson.tms.batch.job.decision;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

import com.humuson.tms.batch.job.constrants.JobParamConstrants;

@Slf4j
public class DuplicatedTempDataDeleteDecider implements JobExecutionDecider {

	@Override
	public FlowExecutionStatus decide(JobExecution jobExecution,
			StepExecution stepExecution) {
			
			String deduplicationYn = "DUPLICATED_" + stepExecution.getJobParameters().getString(JobParamConstrants.DEDUPLICATION_YN);
			
			log.info("[DuplicatedTempDataDeleteDecider] deduplicationYn : {}", deduplicationYn);
			return new FlowExecutionStatus(deduplicationYn);
	}

}
