package com.humuson.tms.batch.job.decision;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;

@Slf4j
public class ChannelTypeDecider implements JobExecutionDecider {

	@Override
	public FlowExecutionStatus decide(JobExecution jobExecution,
			StepExecution stepExecution) {
		if (ExitStatus.COMPLETED.getExitCode().equals(stepExecution.getExitStatus().getExitCode())) {
			String channelType = stepExecution.getJobExecution()
					.getExecutionContext().get(JobExecutionContextConstrants.KEY_CHN_TYPE).toString();
			
			log.info("channelType : {}", channelType);
			return new FlowExecutionStatus(channelType);
		} else {
			log.error("Step ExistCode:{}, param[{}]", 
					stepExecution.getExitStatus().getExitCode(), stepExecution.toString());
		}
		return new FlowExecutionStatus(ExitStatus.STOPPED.getExitCode());
	}

}
