package com.humuson.tms.batch.job.decision;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

import com.humuson.tms.batch.job.constrants.JobExecutionContextConstrants;

import lombok.extern.slf4j.Slf4j;

/**
 * 타겟 건수에 따라 single thread or multi thread로 구동 여부를 판단
 * @author hyogun
 *
 */
@Slf4j
public class AllDeviceDecider implements JobExecutionDecider {
	
	private int singleThreadMaxTargetCount = 1000;
	
	private String ALL_DEVICE="A";
	
	@Override
	public FlowExecutionStatus decide(JobExecution jobExecution,
			StepExecution stepExecution) {
		
		log.info("[AllDeviceDecider] ExitCode :{}, TAGET_USER_TYPE :{}",stepExecution.getExitStatus().getExitCode(), stepExecution.getJobExecution()
				.getExecutionContext().getString(JobExecutionContextConstrants.TAGET_USER_TYPE,null));
		
		if (ExitStatus.COMPLETED.getExitCode().equals(stepExecution.getExitStatus().getExitCode()) 
				&& ALL_DEVICE.equalsIgnoreCase(stepExecution.getJobExecution()
				.getExecutionContext().getString(JobExecutionContextConstrants.TAGET_USER_TYPE,null) )) {
			String step1 = stepExecution.getJobExecution()
					.getExecutionContext().getString(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP1,"unpass");
			String step2 = stepExecution.getJobExecution()
						.getExecutionContext().getString(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP2,"unpass");
			if ("unpass".equalsIgnoreCase(step1)) {
				stepExecution.getJobExecution()
				.getExecutionContext().put(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP1,"pass");
				return new FlowExecutionStatus("REMAIN_TARGETING");
			} else {
				if("pass".equalsIgnoreCase(step1) && "unpass".equalsIgnoreCase(step2)){
					stepExecution.getJobExecution()
					.getExecutionContext().put(JobExecutionContextConstrants.TAGET_ALL_DEVICE_STEP2,"pass");
				}
				return new FlowExecutionStatus("END");
			}
		} else {
			return new FlowExecutionStatus("END");
		}
	}

}
