package com.humuson.tms.batch.item.database;

import java.util.concurrent.atomic.AtomicInteger;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;

import lombok.extern.slf4j.Slf4j;

/**
 * SMS 결과 테이블의 데이터 검증 클래스
 * @author hyogun
 *
 */
@Slf4j
public class SmsLogProcessor implements ItemProcessor<PushResultLog, PushResultLog>, StepExecutionListener {
	
	AtomicInteger errorCount = new AtomicInteger();
	
	@Override
	public PushResultLog process(PushResultLog item) throws Exception {
		
		String  postId = item.getPostId();
		
		if (item.getChannelSendType().equals(ChannelSendType.AUTO)) {
			int pos = postId.lastIndexOf('_');
			if (pos > -1) {
				item.setWorkday(postId.substring(0, pos));
				item.setSeqNo(postId.substring(pos+1));
			}
		}
		
		return item;
	}
	
	@Override
	public void beforeStep(StepExecution stepExecution) {
		log.debug("SmsLogProcessor beforeStep");
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		log.info("push que log error count : {}", errorCount.get());
		return stepExecution.getExitStatus();
	}
}

