package com.humuson.tms.batch.item.database;

import org.springframework.beans.factory.annotation.Value;

import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.constrants.PushResponseConstants;
import com.humuson.tms.constrants.StatusType;

/**
 * 푸시 재발송 프로세서
 * @author hyogun
 *
 */
public class PushReSendProcessor extends PushSendProcessor {

	@Value("#{config['use.resend.gcm.for.private.failed']}")
	private boolean useResendGcm;
	
	/**
	 * 푸시 재발송에서는 별도 유효성 체크를 하지 않음
	 */
	@Override
	protected boolean checkValidation(PushQueue item) {
		return true;
	}
	
	@Override
	public PushQueue process(PushQueue item) throws Exception {
		
		if (StatusType.PENDDING.getCode().equals(item.getSendStatus())) {
			item.setSendStatus(StatusType.ERROR.getCode());
			item.setErrorCode(PushResponseConstants.TTL_EXPIRED);
		}
		
		if (!useResendGcm
				&& PushResponseConstants.SENDING.equals(item.getErrorCode())) {
			item.setSendStatus(StatusType.ERROR.getCode());
			item.setErrorCode(PushResponseConstants.TTL_EXPIRED);
		}
		
		return super.process(item);
	}
}

