package com.humuson.tms.batch.item.database;

import java.util.concurrent.atomic.AtomicInteger;

import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;
import com.humuson.tms.batch.service.UpdateResultService;
import com.humuson.tms.common.util.StringUtils;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 푸시 결과 테이블의 데이터 검증 클래스
 * @author hyogun
 *
 */
@Slf4j
public class PushQueLogProcessor implements ItemProcessor<PushResultLog, PushResultLog>{
	
	private static final String IOS = "I";
	private static final String READ = "R";
	private static final String CLICK = "C";
	private static final String SEND = "S";
	AtomicInteger errorCount = new AtomicInteger();
	@Setter private String updateCheckFlag;
	
	@Setter private String selectExistCampClickInfo;
	@Setter private String selectExistAutoClickInfo;
	@Autowired private UpdateResultService updateResultServiceImpl; 
	@Override
	public PushResultLog process(PushResultLog item) throws Exception {
		
		if (StringUtils.isNull(item.getReqUid())
				|| StringUtils.isNull(item.getType())
				|| StringUtils.isNull(item.getRtnType())) {
			errorCount.incrementAndGet();
			item.setCheckFlag("F");
			updateResultServiceImpl.updateCheckFlag(updateCheckFlag, item);
			return null;
		}
		
		if (!item.getType().startsWith("CC") && !item.getType().startsWith("AA")) {
			errorCount.incrementAndGet();
			item.setCheckFlag("F");
			updateResultServiceImpl.updateCheckFlag(updateCheckFlag, item);
			return null;
		}
		
		String  postId = item.getPostId();
		
		if (item.getChannelSendType().equals(ChannelSendType.AUTO)
				&& !StringUtils.isNull(postId)) {
			int pos = postId.lastIndexOf('_');
			item.setWorkday(postId.substring(0, pos));
			item.setSeqNo(postId.substring(pos+1));
		}
		
		if (SEND.equals(item.getRtnType())) {
			item.setPushedCnt(1);
			if (!"00".equals(item.getErrorCode())) {
				item.setFailCnt(1);
			}
		} else if (READ.equals(item.getRtnType())) {
			item.setOpenCnt(1);
			item.setErrorCode("");
			if (IOS.equals(item.getAppOs())) {
				item.setOpenCntIos(1);
			} else {
				item.setOpenCntAndroid(1);
			}
		} else if (CLICK.equals(item.getRtnType())) {
			int existCount;
			
			if (item.getChannelSendType().equals(ChannelSendType.AUTO)) {
				existCount = this.updateResultServiceImpl.alreadExistClickInfo(selectExistAutoClickInfo, 
						new BeanPropertySqlParameterSource(item));
			} else {
				existCount = this.updateResultServiceImpl.alreadExistClickInfo(selectExistCampClickInfo,
						new BeanPropertySqlParameterSource(item));
			}
			
			if (existCount > 0) {
				item.setDupClickCnt(1);
			} else {
				item.setClickCnt(1);
				item.setDupClickCnt(1);
				if (IOS.equals(item.getAppOs())) {
					item.setClickCntIos(1);
				} else {
					item.setClickCntAndroid(1);
				}
			}
			item.setErrorCode("");
		}
		
		if (log.isDebugEnabled()) {
			log.debug("item :{}", item.toString());
		}
		
		return item;
	}
}

