package com.humuson.tms.batch.item.database;

import java.util.concurrent.atomic.AtomicInteger;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.constrants.StatusType;

import lombok.extern.slf4j.Slf4j;

/**
 * 각 채널 타겟팅 추출 데이터에 대한 검증 클래스
 * @author hyogun
 *
 */
@Slf4j
public class PrvFeedbackProcessor implements ItemProcessor<PushResult, PushResult>, StepExecutionListener {

	@Autowired protected PushResultService pushResultService;
	
	protected AtomicInteger readerCount = new AtomicInteger();
	protected AtomicInteger errorCount = new AtomicInteger();
	protected AtomicInteger writerCount = new AtomicInteger();
	
	@Override
	public PushResult process(PushResult item) throws Exception {
		readerCount.incrementAndGet();
		
		if (StatusType.ERROR.getCode().equals(item.getSendStatus())) {
			errorCount.incrementAndGet();
			return null;
		}
		writerCount.incrementAndGet();
		return item;
	}
	
	
	@Override
	public void beforeStep(StepExecution stepExecution) {
		log.info("private feedback beforeStep");
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		log.info("private feedback [read:{}, error:{}, writer:{}]",
				readerCount.get(), errorCount.get(), writerCount.get());
		return stepExecution.getExitStatus();
	}
}

