package com.humuson.tms.batch.item.database;

import static com.humuson.tms.batch.job.constrants.JobParamConstrants.APP_GRP_KEY;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.DirectQueue;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.PushInfoService;

import lombok.extern.slf4j.Slf4j;

/**
 * TMS_QUEUE 연동 푸시 발송 프로세서
 * @author hyogun
 *
 */
@Slf4j
public class DirectPushSendProcessor implements ItemProcessor<DirectQueue, DirectQueue>, StepExecutionListener {

	protected App appInfo;
	protected Map<Integer, String> appOsMap = new ConcurrentHashMap<Integer, String>();
	
	@Autowired protected PushInfoService<App, PushMessage> pushInfoService;
	@Autowired protected JdbcTemplate jdbcTemplate;
	
	protected boolean checkValidation(DirectQueue item) {
		return true;
	}
	
	@Override
	public void beforeStep(StepExecution stepExecution) {
		String appGrpKey = stepExecution.getJobExecution().getJobParameters().getString(APP_GRP_KEY);
		appInfo = pushInfoService.getAppInfo(appGrpKey);
		appOsMap = appInfo.getAppOsMap();
	}
	
	@Override
	public DirectQueue process(DirectQueue item) throws Exception {
		
		if (!this.checkValidation(item)) {
			log.error("[DIRECT] check validation error []", item.toString());
			return null;
		}
		
		return item;
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		return stepExecution.getExitStatus();
	}
}

