package com.humuson.tms.batch.item.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.springframework.batch.item.database.ItemPreparedStatementSetter;

import com.humuson.tms.batch.domain.AppDeviceDeleteInfo;

/**
 * Long Item에 대한 Setter
 * @author hyogun
 *
 */
public class AppDeviceDeleteInfoSetter implements ItemPreparedStatementSetter<AppDeviceDeleteInfo> {

	@Override
	public void setValues(AppDeviceDeleteInfo item, PreparedStatement ps) throws SQLException {
		ps.setLong(1, item.getDeviceId());
		ps.setString(2, item.getRegDate());
		ps.setString(3, item.getRegDate());
	}
}
