package com.humuson.tms.batch.item.database;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.apache.http.HttpStatus;
import org.springframework.util.Assert;

import com.humuson.amc.client.model.AudienceScrollResponse;
import com.humuson.amc.client.model.IteratorResponse;
import com.humuson.amc.client.model.request.ContactRequest;
import com.humuson.amc.client.model.response.Contact;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author sgeom
 *
 */
@Slf4j
public class AmcAudienceIterateItemReader extends AmcAbstractIterateItemReader<ContactRequest,Contact, AudienceScrollResponse>  {
	
	@Setter private int audienceSeq;
	
	/* (non-Javadoc)
	 * @see com.humuson.tms.batch.item.database.AmcAbstractIterateItemReader#initRequestData()
	 * response = client.contact.getIterator(request) 까지 처리해주고 apiRead메시지에서는 이터레이팅만함.
	 */
	@Override
	protected void initRequestData() {
		request = new ContactRequest();
//		request.setSiteKey(amcSiteKey);
//		request.setChannelKey(amcChannelKey);
		request.setSize(getItemSize);
		request.setAudienceSeq(String.valueOf(audienceSeq));
		request.setTimeout(requestTimeoutMillisecond);
//		response.get().getTotalCount()
		response = client.contact.getIterator(request);
	}
	
	
	protected void apiRead() {
		
		if (results == null) {
			results = new CopyOnWriteArrayList<Contact>();
		}
		else {
			results.clear();
		}
		
//		if(response  == null)
//			response = client.contact.getIterator(request);
		
		List<Contact> contacts = null;
		try {
			contacts = response.get().getContacts();
			Assert.isTrue(HttpStatus.SC_OK == response.getCode(), "Http Request Fail Retrun code : [" + response.getCode() + "] / Error Msg : ["+response.getMsg()+"]");
		} catch (Exception e) {
		}
		
		results.addAll((Collection<Contact>)contacts);
	}

	
}