package com.humuson.tms.batch.item.database;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

import org.apache.http.HttpStatus;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import com.humuson.amc.client.AmcClient;
import com.humuson.amc.client.model.Page;
import com.humuson.amc.client.model.Response;
import com.humuson.amc.client.model.request.ContactRequest;
import com.humuson.amc.client.model.response.Contact;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * {@link org.springframework.batch.item.ItemReader} for reading database
 * records using JDBC in a paging fashion.
 * </p>
 * 
 * <p>
 * It executes the SQL built by the {@link PagingQueryProvider} to retrieve
 * requested data. The query is executed using paged requests of a size
 * specified in {@link #setPageSize(int)}. Additional pages are requested when
 * needed as {@link #read()} method is called, returning an object corresponding
 * to current position. On restart it uses the last sort key value to locate the
 * first page to read (so it doesn't matter if the successfully processed items
 * have been removed or modified).
 * </p>
 * 
 * <p>
 * The performance of the paging depends on the database specific features
 * available to limit the number of returned rows. Setting a fairly large page
 * size and using a commit interval that matches the page size should provide
 * better performance.
 * </p>
 * 
 * <p>
 * The implementation is thread-safe in between calls to
 * {@link #open(ExecutionContext)}, but remember to use
 * <code>saveState=false</code> if used in a multi-threaded client (no restart
 * available).
 * </p>
 * 
 * @author Thomas Risberg
 * @author Dave Syer
 * @author Michael Minella
 * @since 2.0
 */
/**
 * 
 * 
 * @author sgeom
 *
 * @param <T> : 
 */
@Slf4j
public class AmcApiPagingItemReader<T> extends AbstractPagingItemReader<T> implements InitializingBean {

	private AmcClient client; 
	@Setter private String amcSiteKey;
	@Setter private String amcChannelKey;
	@Setter private int audienceSeq;
	
	// -1 not Set
	@Setter private int requestTimeoutMillisecond = -1;
	
	@Override
	public void afterPropertiesSet() throws Exception {
		client = new AmcClient.Builder().setBaseUri("http://119.207.76.91:7082/api").build();
	}

	@Override
	protected void doReadPage(){
		if (results == null) {
			results = new CopyOnWriteArrayList<T>();
		}
		else {
			results.clear();
		}
		
		ContactRequest request = new ContactRequest();
//		request.setSiteKey(amcSiteKey);
//		request.setChannelKey(amcChannelKey);
		request.setSize(getPageSize());
		request.setPage(getPage()+1);
//		log.info("getPage : {}", getPage());
		request.setAudienceSeq(String.valueOf(audienceSeq));
		if(requestTimeoutMillisecond != -1 && requestTimeoutMillisecond >= 0){
			request.setTimeout(20000);
		}
		long start = System.currentTimeMillis();
		Response<Page<Contact>> response = null;
//		Response<Page<Contact>> response = client.contact.get(request);
		log.info("elapse time : {}" ,System.currentTimeMillis() - start);
		Assert.isTrue(HttpStatus.SC_OK == response.getCode(), "Http Request Fail Retrun code : [" + response.getCode() + "] / Error Msg : ["+response.getMsg()+"]");
		if(response.get() != null){
			Collection<T> result = (Collection<T>) response.get().getContent();
			
			if(result !=null ){
				results.addAll(result);
			}
		}
	}

	@Override
	protected void doJumpToPage(int itemIndex) {
		//일단 아무것도 안함.
//		AudienceRequest request = new AudienceRequest();
//		request.setSiteKey(amcSiteKey);
//		request.setChannelKey(amcAppKey);
//		request.setPage(getPage());
//		
//		ArrayList<T> item;
//		
//		Response<Page<Audience>> response = client.audience.get(request);
//		if(HttpStatus.SC_OK != response.getCode()){
////			throw new HttpException("Http Request Fail Retrun code : [" + response.getCode() + "] / Error Msg : ["+response.getMsg()+"]");
//		};
	}
	
}
