package com.humuson.tms.batch.item.database;

import java.util.List;

import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.util.ClassUtils;

import com.humuson.amc.client.AmcClient;
import com.humuson.amc.client.model.IteratorResponse;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author sgeom
 *
 */
@Slf4j
public abstract class AmcAbstractIterateItemReader<T,R,C> extends AbstractItemCountingItemStreamItemReader<R>{
	
	protected AmcClient client; 
	@Setter private String baseUrl;
	@Setter protected String amcSiteKey;
	@Setter protected String amcChannelKey;
	@Setter protected int getItemSize;
	
	
	T request;
	
	protected IteratorResponse<C> response = null;
	
	private volatile boolean initialized = false;

	private volatile int current = 0;

	
	Object lock = new Object();
	
	/**
	 * requestTimeoutMillisecond 
	 * default 5000
	 */
	@Setter protected int requestTimeoutMillisecond = 5000;
	
	protected volatile List<R> results;

	public AmcAbstractIterateItemReader() {
		setName(ClassUtils.getShortName(AmcAbstractIterateItemReader.class));
	}
	
	@Override
	protected R doRead() throws Exception {
		synchronized (lock) {

			if (results == null || results.isEmpty()) {
				apiRead();
				response = response.next();
				if (current >= getItemSize) {
					current = 0;
				}

			}

			int next = current++;
			if (next < results.size()) {
				return results.get(next);
			}
			else {
				return null;
			}

		}
	}

	abstract protected void apiRead();
	
	abstract protected void initRequestData();

	@Override
	protected void doOpen() throws Exception {
		if (baseUrl != null){
			client = new AmcClient.Builder().setBaseUri(baseUrl).build();
		}else{
			client = new AmcClient.Builder().setBaseUri("http://119.207.76.91:7082/api").build();
		}
		
		initRequestData();
	}

	@Override
	protected void doClose() throws Exception {
		
	}

}