package com.humuson.tms.batch.item.apns;

import java.util.List;

import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;

import com.humuson.tms.batch.domain.ApnsFeedback;
import com.humuson.tms.batch.service.AppUserRemover;

import lombok.extern.slf4j.Slf4j;

/**
 * APNS Feedback List에 대하여 TMS_APP_DEVICE_LIST의 token을 noToken으로 변경
 * @author hyogun
 *
 */
@Slf4j
public class ApnsFeedbackItemWriter implements ItemWriter<ApnsFeedback> {
	
	protected static final String USE = "Y";

	@Autowired protected AppUserRemover appUserRemover;
	
	@Override
	public void write(final List<? extends ApnsFeedback> rawData) throws Exception {
		try {
			@SuppressWarnings("unchecked")
			int[] updateIds =  appUserRemover.updateIosUnActiveToken((List<ApnsFeedback>)rawData);
			log.info("APNS Feedback Update Count :{}", updateIds.length);
		} catch (Exception e) {
			log.error("APNS Feedback Batch Update fail", e);
			
			for (ApnsFeedback feedback : rawData) {
				try {
					appUserRemover.updateIosUnActiveToken(feedback);
				} catch (Exception e2) {
					log.error("APNS Feedback err [grpId:{}, token:{}]", feedback.getGrpId(), feedback.getUuid());
				}
			}
		}
	}
}
