package com.humuson.tms.batch.integration.transformer;

import java.util.Map;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.integration.launch.JobLaunchRequest;

import com.humuson.tms.mq.model.JobRequest;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class JmsMessageToJobRequest implements MessageToJobRequest {
	
	private JobRegistry jobRegistry;
	
	/**
	 * 
	 * @param jobRegistry
	 */
	public JmsMessageToJobRequest(JobRegistry jobRegistry) {
		this.jobRegistry = jobRegistry;
	}
	
	@Override
	public JobLaunchRequest toRequest(JobRequest request) {
		JobParametersBuilder builder = new JobParametersBuilder();
		
		log.info("toRequest :{}", request.toString());
		
		Job job = null;
		try {
			job = jobRegistry.getJob(request.getJobName());
			Map<String, Object> param = request.getJobParameter();
			for (String key : param.keySet()) {
				Object value = param.get(key);
				if (value instanceof Long) {
					builder.addLong(key, (Long)value);
				} else if (value instanceof String){
					builder.addString(key, String.valueOf(value));
				} else {
					log.error("unknown instance [key:{}, value:{}]", key, value);
				}
			}
			return new JobLaunchRequest(job, builder.toJobParameters());
		} catch (NoSuchJobException e) {
			if (request.getJobName() == null) {
				log.error("Request Job name is null", e);
			} else {
				log.error("NoSuchJobException [{}]", request.getJobName(), e);
			}
		}
		
		return null;
	}
}
