package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class SmsResultLog extends BaseResult {
	
	public static final String ORG_TRAN_ID = "ORG_TRAN_ID";
	public static final String RESULT = "RESULT";
	public static final String TO_PHONE = "TO_PHONE";
	
	@Setter @Getter private String orgTranId;
	@Setter @Getter private String result;
	@Setter @Getter private String toPhone;
	
	@Override
	public Map<String, Object> toMap() {
		Map<String, Object> map = super.toMap();
		
		Field[] fields = super.getClass().getSuperclass().getDeclaredFields();
		
		for (Field field : fields) {
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		
		return map;
	}
}
