package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import com.humuson.tms.constrants.ChannelType;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class SiteInfo extends java.lang.Object {
	
	public static final String PUSH_USER_CNT = "PUSH_USER_CNT";
	public static final String EMAIL_USER_CNT = "EMAIL_USER_CNT";
	public static final String SMS_USER_CNT = "SMS_USER_CNT";
	public static final String SITE_ID = "SITE_ID";
	
	@Setter @Getter private int siteId;
	@Setter @Getter private long  pushUserCnt;
	@Setter @Getter private long  emailUserCnt;
	@Setter @Getter private long  smsUserCnt;
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		Field[] fields = super.getClass().getDeclaredFields();
		
		for (Field field : fields) {
			
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		return map;
	}
}
