package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class PushResultLog extends BaseResult {
	
	public static final String ROW_ID = "ROW_ID";
	public static final String APP_GRP_ID = "APP_GRP_ID";
	public static final String DATA = "DATA";
	public static final String REQ_UID = "REQ_UID";
	public static final String LINK = "LINK";
	public static final String OS = "OS";
	public static final String TYPE = "TYPE";
	
	@Setter @Getter private String rowId = "";
	@Setter @Getter private int appGrpId;
	@Setter @Getter private String resultData;
	@Setter @Getter private String reqUid;
	
	@Setter @Getter private String appOs;
	@Setter @Getter private String clickId; 
	@Setter @Getter private String clickUrl;
	@Setter @Getter private int clickCnt;
	@Setter @Getter private int dupClickCnt;
	@Setter @Getter private int clickCntIos;
	@Setter @Getter private int clickCntAndroid;
	@Setter @Getter private int openCnt;
	@Setter @Getter private int openCntAndroid;
	@Setter @Getter private int openCntIos;
	
	@Override
	public Map<String, Object> toMap() {
		Map<String, Object> map = super.toMap();
		
		Field[] fields = this.getClass().getSuperclass().getDeclaredFields();
		
		for (Field field : fields) {
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		
		return map;
	}
}
