package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import com.humuson.tms.constrants.PushResponseConstants;
import com.humuson.tms.constrants.StatusType;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
@Data
@Accessors(chain=true)
@EqualsAndHashCode(callSuper=false)
public class PushResult {
	
	public static final int MAX_CHUNK_SIZE = 10;
	private Random rnd = new Random();
	
	private int appGrpId;
	private String rowId;
	private Long pushId;
	private int deviceId;
	private String reqUid;
	private String custId = "";
	private String errorCode;
	private String changedToken;
	private String appOs;
	private String sendStatus;
	private String resultData;
	private String resDate;
	private String rtnType = "S";
	private String chunkId;
	private String sendTime;
	private String recvTime;
	private boolean isMqSending = false;
	private String serverId;
	
	/**
	 * @param appGrpId : appGrpId
	 * @param errorCode : push result code
	 * @param id : push_id + device_id + req_uid + cust_id
	 * @param os : A(android), I(ios)
	 */
	public PushResult(int appGrpId, String errorCode, String id, String appOs, String rowId) {
		this.appGrpId = appGrpId;
		this.errorCode = errorCode;
		// id = pushId+'_'+deviceId+'_'+reqUid+'_'+custId
		if (id.indexOf("&&") >= 0) {
			String[] ids = id.split("&&");
			// MQ Sending시 pushId는 문자로 들어와 파싱에 실패함
			try{
				this.pushId = Long.parseLong(ids[0]);
			}catch (Exception e){
				isMqSending = true;
				// MQ Sending 이면 : 구분자로 serverId를 붙여서 넘어옴.
				serverId = id.split(":")[1];
			}
			this.deviceId = Integer.parseInt(ids[1]);
			this.reqUid = ids[2];
			if (ids.length > 3) {
				if(ids[3].split(":").length >1){
					this.custId = ids[3].split(":")[0];
				}else{
					this.custId = ids[3];
				}
			}
		}else if(id.indexOf("AA") >= 0 && id.indexOf("_") >=0){
			//Rainboots PushResult
			String[] ids = id.split("_");
			// MQ Sending시 pushId는 문자로 들어와 파싱에 실패함
			try{
				this.pushId = Long.parseLong(ids[0]);
			}catch (Exception e){
				isMqSending = true;
			}
			this.deviceId = Integer.parseInt(ids[1]);
			this.reqUid = ids[2]+"_"+ids[3]+"_"+ids[4];
			if (ids.length > 5) {
				this.custId = ids[5];
			}
		}else if(id.indexOf("_") >=0){
			//Rainboots PushResult
			String[] ids = id.split("_");
			// MQ Sending시 pushId는 문자로 들어와 파싱에 실패함
			try{
				this.pushId = Long.parseLong(ids[0]);
			}catch (Exception e){
				isMqSending = true;
			}
			this.deviceId = Integer.parseInt(ids[1]);
			if(ids.length <= 4){
				this.reqUid = ids[2];
				if (ids.length > 3) {
					this.custId = ids[3];
				}
			}else{
				// cust_id에 _가 들어갔을때
				this.reqUid = ids[2]+ids[3];
				if (ids.length > 5) {
					this.custId = ids[4]+ids[5];
				}
			}
		}
		chunkId = String.format("%02d", rnd.nextInt(MAX_CHUNK_SIZE)+1);
		this.appOs = appOs;
		if (PushResponseConstants.SENDING.equals(errorCode)) {
			this.sendStatus = StatusType.SENDING.getCode();
		} else if (PushResponseConstants.MQ_SENDING.equals(errorCode)) { 
			this.sendStatus = StatusType.MQ_SENDING.getCode();
		} else if (PushResponseConstants.SENDING_CCS.equals(errorCode)) { 
			this.sendStatus = StatusType.CCS_SENDING.getCode();
		} else {
			if (PushResponseConstants.CHANGED_SUCCESSFUL.equals(errorCode)
					|| PushResponseConstants.SUCCESSFUL.equals(errorCode)) {
				this.sendStatus = StatusType.COMPLETE.getCode();
			} else {
				this.sendStatus = StatusType.ERROR.getCode();
			}
		}
//		log.debug("PushResult : {}  ", pushId + "_"+deviceId+"_"+reqUid+"_"+custId);
		
		if(rowId != null && !"".equals(rowId)){
			this.rowId = rowId ;
		}
		
	}
	
	public String getErrorCode() {
		if (PushResponseConstants.CHANGED_SUCCESSFUL.equals(this.errorCode)
				|| PushResponseConstants.SUCCESSFUL.equals(this.errorCode)) {
			this.errorCode = PushResponseConstants.SUCCESSFUL;
		}
		return this.errorCode;
	}
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		
		Field[] fields = getClass().getDeclaredFields();
		
		for (Field field : fields) {
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		
		return map;
	}
}
