package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
@Data
@Accessors(chain=true)
@EqualsAndHashCode(callSuper=false)
public class PushQueue {
	public static final String SEND_LIST_ROW_ID = "ROW_ID";
	public static final String PUSH_ID = "PUSH_ID";
	public static final String APP_GRP_KEY = "APP_GRP_KEY";
	public static final String REQ_UID = "REQ_UID";
	public static final String CUST_ID = "CUST_ID";
	public static final String DEVICE_ID = "DEVICE_ID";
	public static final String PUSH_TOKEN = "PUSH_TOKEN";
	public static final String PUSH_TYPE = "PUSH_TYPE";
	public static final String RCV_NAME = "RCV_NAME";
	public static final String RCV_PHONE = "RCV_PHONE";
	public static final String NOTI_FLAG = "NOTI_FLAG";
	public static final String SEND_STATUS = "SEND_STATUS";
	public static final String ERROR_CODE = "ERROR_CODE";
	
	private PushMessage pushMessage;
	private InAppMessage inAppMsg;
	private String rowId;
	private long pushId;
	private String appGrpKey;
	private int appId;
	private String serverId;
	private String sendType;
	private String reqUid;
	private String custId;
	private long deviceId;
	private String pushToken;
	private String rcvName;
	private String rcvPhone;
	private String notiFlag;
	private String pushType;
	private String sendStatus;
	private String errorCode;
	
	private String appOs;
	private String chunkId;
	private int appGrpId;
	private String rtnType = "S";
	private String resultData;
	private String resDate;
	private String recvTime;
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		
		Field[] fields = getClass().getDeclaredFields();
		
		for (Field field : fields) {
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		
		return map;
	}
}
