package com.humuson.tms.batch.domain;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 
 * @author hyogun
 *
 */
@Data
@Accessors(chain=true)
public class Feedback {
	public static final String PUSH_ID = "PUSH_ID";
	public static final String APP_KEY = "APP_KEY";
	public static final String PUSH_RESULT_CD = "PUSH_RESULT_CD";
	public static final String RCV_TIME = "RCV_TIME";
	public static final String SEND_TIME = "SEND_TIME";
	public static final String QUE_ID = "QUE_LOG_ID";
	
	private long pushId;
	private int deviceId;
	private String appKey;
	private String pushResultCd;
	private String rcvTime;
	private String sendTime;
	
	public Feedback() {
		
	}
	/**
	 * 
	 * @param id
	 * @param appKey
	 * @param pushResultCd
	 * @param rcvTime
	 * @param sendTime
	 */
	public Feedback(String id, String appKey, String pushResultCd, String rcvTime, String sendTime) {
		if (id.indexOf('_') > -1) {
			String[] ids = id.split("_");
			this.pushId = Long.parseLong(ids[0]);
			this.deviceId = Integer.parseInt(ids[1]);
		}
		
		this.appKey = appKey;
		this.pushResultCd = pushResultCd;
		this.rcvTime = rcvTime;
		this.sendTime = sendTime;
	}
}
