package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
@Data
@Accessors(chain=true)
@EqualsAndHashCode(callSuper=false)
public class DirectQueueResult {
	public static final String SEQ = "SEQ";
	
	private long seq;
	private String chGubun;
	private String msgTpCd;
	private String reqUid;
	private String toId;
	private String rtnType = "S";
	private String rtnCode = "--";
	
	public DirectQueueResult(DirectQueue item) {
		this.chGubun = item.getChGubun();
		this.msgTpCd = item.getMsgTpCd();
		this.reqUid = item.getReqUid();
		this.toId = item.getToId();
	}
	
	public DirectQueueResult(DirectQueue item, String rtnCode) {
		this.chGubun = item.getChGubun();
		this.msgTpCd = item.getMsgTpCd();
		this.reqUid = item.getReqUid();
		this.toId = item.getToId();
	}
	
	public DirectQueueResult(DirectQueue item, String rtnType, String rtnCode) {
		this.chGubun = item.getChGubun();
		this.msgTpCd = item.getMsgTpCd();
		this.reqUid = item.getReqUid();
		this.toId = item.getToId();
	}
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		
		Field[] fields = getClass().getDeclaredFields();
		
		for (Field field : fields) {
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		
		return map;
	}
}
