package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
@Data
@Accessors(chain=true)
@EqualsAndHashCode(callSuper=false)
public class DirectQueue {
	public static final String SEQ = "SEQ";
	public static final String CH_GUBUN = "CH_GUBUN";
	public static final String TMS_M_ID = "TMS_M_ID";
	public static final String TMS_M_NAME = "TMS_M_NAME";
	public static final String TMS_M_TOKEN = "TMS_M_TOKEN";
	public static final String SUBJECT = "SUBJECT";
	public static final String CONTENT = "CONTENT";
	public static final String PU_IN_APP = "PU_IN_APP";
	public static final String PUSH_VALUE = "PUSH_VALUE";
	public static final String DEVICE_ID = "DEVICE_ID";
	public static final String IMG_URL = "IMG_URL";
	public static final String REG_DATE = "REG_DATE";
	public static final String MSG_TP_CD = "MSG_TP_CD";
	public static final String REQ_UID = "REQ_UID";
	public static final String PRIORITY = "PRIORITY";
	public static final String TO_ID = "TO_ID";
	
	public static final String APP_GRP_KEY = "APP_GRP_KEY";
	public static final String APP_GRP_ID = "APP_GRP_ID";
	public static final String NOTI_FLAG = "NOTI_FLAG";
	public static final String OS = "OS";
	public static final String TTL = "TTL";
	
	
	private long seq;
	private String appGrpKey;
	private int appGrpId;
	
	private String chGubun;
	private String reqUid;
	private String custId;
	private long deviceId;
	private String pushToken;
	private String custName;
	
	private String subject;
	private String content;
	private String inappMsg;
	private String pushValue;
	private String imgUrl;
	private String regDate;
	private String msgTpCd;
	private int  priority;
	private String toId;
	
	private int appId;
	private String appOs;
	private String notiFlag = "N";
	
	private String sendStatus;
	private String errorCode;
	
	private int ttl;
	
	private String rtnType = "S";
	private String rtnCode = "--";
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		
		Field[] fields = getClass().getDeclaredFields();
		
		for (Field field : fields) {
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		
		return map;
	}
}
