package com.humuson.tms.batch.domain;

/**
 * 채널 전송 타입(자동 / 캠페인)
 * @author hyogun
 *
 */
public enum ChannelSendType {
	AUTO("AUTO"),
	CAMP("CAMP"),
	UNKNOWN("UNKNOWN");

	private String code;

	private ChannelSendType(String code) {
		this.code = code;
	}

	public String getCode() {
		return code;
	}
	
	/**
	 * 
	 * @param code
	 * @return
	 * @throws IllegalArgumentException
	 */
	public static ChannelSendType valueOfCode(String code) throws IllegalArgumentException {
		for (ChannelSendType eCode : ChannelSendType.values()) {
			if (eCode.getCode() == code) {
				return eCode;
			}
		}

        throw new IllegalArgumentException("No enum constant " + code);
    }
}
