package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import com.humuson.tms.constrants.ChannelType;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class BaseResult extends java.lang.Object {
	
	public static final String ID = "ID";
	public static final String CHANNEL_SEND_TYPE = "CHANNEL_SEND_TYPE";
	public static final String CHANNEL_TYPE = "CHANNEL_TYPE";
	public static final String RTN_TYPE = "RTN_TYPE";
	public static final String ERROR_CODE = "ERROR_CODE";
	public static final String POST_ID = "POST_ID";
	public static final String CUST_ID = "CUST_ID";
	public static final String MEMBER_ID = "MEMBER_ID";
	public static final String LIST_TABLE = "LIST_TABLE";
	public static final String T_DATE = "T_DATE";
	public static final String DELIVER_TIME = "DELIVER_TIME";
	public static final String PUSHED_CNT = "PUSHED_CNT";
	public static final String FAIL_CNT = "FAIL_CNT";
	public static final String MMDD = "MMDD";
	public static final String HH24 = "HH24";
	
	@Setter @Getter private String id;
	@Setter @Getter private ChannelSendType channelSendType;
	@Setter @Getter private ChannelType channelType;
	@Setter @Getter private String rtnType;
	@Getter private String postId;
	@Setter @Getter private String custId;
	@Getter private String memberId;
	@Setter @Getter private String listTable;
	@Setter @Getter private String errorCode;
	@Setter @Getter private int pushedCnt;
	@Setter @Getter private int failCnt;
	@Setter @Getter private String tdate;
	@Setter @Getter private String deliverTime;
	@Setter @Getter private String monthDay;
	@Setter @Getter private String hour;
	@Setter @Getter private String checkFlag = "Y";
	
	@Setter @Getter private String memberIdSeq;
	@Setter @Getter private String workday;
	@Setter @Getter private String seqNo;
	
	@Setter @Getter private String type;
	
	public void setPostId(String postId) {
		this.postId = postId;
	}
	
	public void setMemberId(String memberId) {
		
		int pos = memberId.lastIndexOf('_');
		if (pos > -1) {
			this.memberIdSeq = memberId.substring(pos+1);
			this.memberId = memberId.substring(0, pos);
		} else {
			this.memberId = memberId;
		}
	}
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		Field[] fields = super.getClass().getDeclaredFields();
		
		for (Field field : fields) {
			
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		return map;
	}
}
