package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import com.humuson.tms.constrants.ChannelType;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class AppDeviceDeleteInfo extends java.lang.Object {
	
	public static final String DEVICE_ID = "DEVICE_ID";
	public static final String REG_DATE = "REG_DATE";
	
	@Setter @Getter private long deviceId;
	@Setter @Getter private String  regDate;
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		Field[] fields = super.getClass().getDeclaredFields();
		
		for (Field field : fields) {
			
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		return map;
	}
}
