package com.humuson.tms.batch.domain;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class ApnsFeedback {
	
	@Getter @Setter private long id;
	@Getter @Setter private long grpId;
	@Getter @Setter private String uuid;
	
	/**
	 * @param grpId
	 * @param token
	 */
	public ApnsFeedback(long grpId, String token) {
		this.grpId = grpId;
		this.uuid = token;
	}
	
	/**
	 * @param id
	 * @param grpId
	 * @param token
	 */
	public ApnsFeedback(long id, long grpId, String token) {
		this.id = id;
		this.grpId = grpId;
		this.uuid = token;
	}
	
	/**
	 * 
	 * @return
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> map = new HashMap<String, Object>();
		
		Field[] fields = getClass().getDeclaredFields();
		
		for (Field field : fields) {
			if (!Modifier.isStatic(field.getModifiers())) {
				field.setAccessible(true);
				try {
					map.put(field.getName(), field.get(this));
				} catch (IllegalArgumentException e) {
					log.error("IllegalArgumentException", e);
				} catch (IllegalAccessException e) {
					log.error("IllegalAccessException", e);
				}
			}
		}
		
		return map;
	}
}
