package com.humuson.tms.batch.benchmark;

import lombok.extern.slf4j.Slf4j;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

@Slf4j
public class InitDummyUserTasklet implements Tasklet {
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	private String selectAppUserId;
	private long startUserId;
	
	@Override
	public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
		
		long startId = jdbcTemplate.queryForObject(selectAppUserId, Long.class);
		
		for (long i = startId; i < startUserId; i++) {
			startId = jdbcTemplate.queryForObject(selectAppUserId, Long.class);
		}
		
		log.info("dummy user start appUserId:{}", startId);
		return RepeatStatus.FINISHED;
		
	}
	
	public void setStartUserId(long startUserId) {
		this.startUserId = startUserId;
	}
}	
