package com.humuson.tms.batch;

import org.slf4j.LoggerFactory;
import org.springframework.batch.core.launch.support.JobRegistryBackgroundJobRunner;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class TmsBatchActivator {
	

	static {
		// java 1.6에서 dns의 cache time이 0인 문제를 해결하기 위함
		java.security.Security.setProperty ("networkaddress.cache.ttl" , "60");   
	}
	
	/**
	 * 
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {
		LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
		 
		try {
	      JoranConfigurator configurator = new JoranConfigurator();
	      configurator.setContext(context);
	      context.reset(); 
	      
	      configurator.doConfigure(System.getProperty("conf.path")+"/logback.xml");
	    } catch (JoranException je) {
	    	log.error("logback initializer error", je);
	    }
		
		JobRegistryBackgroundJobRunner.main(args);
	}
}
