package com.humuson.tms.batch;

import lombok.extern.slf4j.Slf4j;

import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;

@Slf4j
public class LogbackInitializer {
	
	public void start() {
		LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
		
		try {
	      JoranConfigurator configurator = new JoranConfigurator();
	      configurator.setContext(context);
	      // Call context.reset() to clear any previous configuration, e.g. default 
	      // configuration. For multi-step configuration, omit calling context.reset().
	      context.reset(); 
	      configurator.doConfigure(System.getProperty("conf.path")+"/logback.xml");
	    } catch (JoranException je) {
	      // StatusPrinter will handle this
	    	log.error("logback initializer error", je);
	    }
	}

}
