package com.google.android.gcm.ccs.server;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Data
@Slf4j
public class XMPPGCMConnection extends XMPPTCPConnection{
	
	private static final int MAX_MESSAGES_PER_CONNECTION = 200;
	
	private volatile boolean isDrainning = false;
	private boolean isRunning = false;
	private volatile boolean isOveflowPendingMessage = false;
	private volatile boolean isBusy = false;
	
	private String apiKey;
	private Long projectNumber;

	public XMPPGCMConnection(XMPPTCPConnectionConfiguration config) {
		super(config);
	}

	
	
	
}
